REBOL [
	subject: "jeu de morpion en CGI"
	author: "Olivier Auverlot"
	version: 1.0
]

affiche_pion: function [ pion ] [ image ] [
	image: copy {<IMG src="NOM_IMAGE">}
	print replace image "NOM_IMAGE" (select images pion)
]

affiche_cases: does [
	use [ i ] [
		print { 
			<TABLE border="2" cellspacing="5">
			<TR>
			<TD><IMG src="casevide.gif"></TD>
		}
		for i 1 3 1 [ print [ {<TD CLASS="Cellule">} i "</TD>" ] ]

		print "</TR>"
		
		pions: head pions
		forall lettres [
			print "<TR>"
			print [ {<TD CLASS="Cellule">} (first lettres) "</TD>" ]
			for i 1 3 1 [
				print "<TD>"
				affiche_pion (first pions)
				pions: next pions
				print "</TD>"
			]
			print "</TR>"	
		]
		print "</TABLE>"
	]
]


demande_mouvement: does [
	use [ formulaire ] [
		pions: head pions
		formulaire: copy {
			<FORM method="get" action="morpion.cgi" name="mouvement" onSubmit="return verif_saisie()">
	    		Votre mouvement: 
	      		<INPUT type="text" name="mvt" size="5" maxlength="2">
      			<INPUT type="hidden" name="pions" value="POSITION_PIONS">
			<INPUT type="hidden" name="prenom" VALUE="PRENOM_HUMAIN">
    			<INPUT type="submit" name="submit" value="Valider" >
			</FORM>	
		} 

		replace formulaire "POSITION_PIONS" pions
		replace formulaire "PRENOM_HUMAIN" query/prenom
		print formulaire
	]
]

case: function [ x y j ] [] [ 
	poke (pick tabpions y) x j 
]

case?: function [ x y ] [] [ 
	pick (pick tabpions y) x 
]

genere_pions: function [] [ x y ] [
	pions: copy ""
	for y 1 3 1 [
		for x 1 3 1 [
			pions: join pions (case? x y)
		]
	]
]

cherche: function [ pion nombre ] [ trouve l nbr ltmp ] [
	trouve: false
	l: 0
	lignes: head lignes
	lsave: copy []
	forall lignes [
		nbr: 0
		l: l + 1
		ltmp: first lignes
		forskip ltmp 2 [
			if (case? (first ltmp) (second ltmp)) = pion [ 
				nbr: nbr + 1 
			]
		]
		if nbr = nombre [ 
			trouve: true
			append lsave l 	; on sauve le numro de la ligne 
		]
	]
	return trouve 
] 

affiche_information: function [ message ] [ lien ] [

	lien: join {<A HREF="morpion.cgi?mvt=XX&pions=000000000&} [ "prenom=" query/prenom {">Nouvelle partie</A>}]
	
	switch(message) [
		"TERMINEE" [ 
			print {<P CLASS="Information">Partie termine - Match nul</P>}
		]
		"HUMAINGAGNE" [ 
			print [ {<P CLASS="Information">Victoire de} query/prenom "</P>" ]
		]
		"ORDINATEURGAGNE" [ 
			print {<P CLASS="Information">Victoire de l'ordinateur</P>}
		]
	]
	print [ "<BR>" lien ]
]


query: make object! decode-cgi-query system/options/cgi/query-string
pions: query/pions

lettres: make string! "ABC"
chiffres: make string! "123"
lsave: make list! 1

images: [ #"0" "casevide.gif" #"1" "pblanc.gif" #"2" "pnoir.gif" ]

lignes: [
	[ 1 1 2 1 3 1 ]
	[ 1 2 2 2 3 2 ]
	[ 1 3 2 3 3 3 ]
	[ 1 1 1 2 1 3 ]
	[ 2 1 2 2 2 3 ]
	[ 3 1 3 2 3 3 ]
	[ 1 1 2 2 3 3 ]
	[ 3 1 2 2 1 3 ]
]


tabpions: array/initial [ 3 3 ] #"0"
pions: head pions
for y 1 3 1 [
	for x 1 3 1 [
		case x y (first pions)
		pions: next pions
	]
] 


msg: copy "CONTINU"

either query/mvt <> "XX" [
	
	msg: none
	; ON JOUE LE COUP DE L'HUMAIN
	cy: index? find lettres (first query/mvt)
	cx: index? find chiffres (second query/mvt) 	
	either (case? cx cy) = #"0" [
		case cx cy #"1"
		genere_pions

		; L'HUMAIN A T'IL GAGNE ? si oui: affichage du message  "VOUS AVEZ GAGNE"
		if (cherche #"1" 3) [ msg: copy "HUMAINGAGNE" ]
		
		; TOUTES LES CASES SONT-ELLE OCCUPEES ?
		if msg = none [
			pions: head pions
			nbr: make integer! 0
			forall pions [ if (first pions) = #"0" [nbr: nbr + 1 ] ]
			if nbr = 0 [ msg: copy "TERMINEE" ]
		]

		; L'ORDINATEUR PEUT-IL PLACER UN 3eme PION ? si oui: affichage du message: "VOUS AVEZ PERDU"
		if msg = none [
			if (cherche #"2" 2) [ 
				lignes: head lignes
				ltmp: pick lignes (first head lsave)
				forskip ltmp 2 [
					if (case? (first ltmp) (second ltmp)) = #"0" [
						case (first ltmp) (second ltmp) #"2"
						genere_pions
						msg: copy "ORDINATEURGAGNE"
					]
				]
			]
		]

		; LE JOUEUR PEUT-IL PLACER UN 3eme PION ? si oui: blocage de l'adversaire
		if msg = none [
			if (cherche #"1" 2) [
				lignes: head lignes
				ltmp: pick lignes (first head lsave)
				forskip ltmp 2 [
					if (case? (first ltmp) (second ltmp)) = #"0" [
						case (first ltmp) (second ltmp) #"2"
						genere_pions
						msg: copy "CONTINU"
					]
				]
			]
		]

		; LA CASE CENTRALE EST-ELLE LIBRE ? si oui: l'ordinateur prend la case centrale
		if msg = none [
			if (case? 2 2) = #"0" [
				case 2 2 #"2"
				genere_pions
				msg: copy "CONTINU"
			]
		]

		; COUP ALEATOIRE ...
		if msg = none [
			until [
				cx: random 3
				cy: random 3
				(case? cx cy) = #"0" 
			]
			case cx cy #"2"
			genere_pions
			msg: copy "CONTINU"
		]

	] [
		; la case est dja occupe
		msg: copy "OCCUPEE"
	]
] [ genere_pions ]

print "Content-type: text/html^/"
print replace {
	<HTML>
	<HEAD>
	<TITLE>Jeu de morpion</TITLE>
	<LINK REL="stylesheet" HREF="morpion.css">
	<SCRIPT language="javascript">
		function verif_saisie() {
			cases = [ "A1","A2","A3","B1","B2","B3","C1","C2","C3" ];
			saisie = document.mouvement.mvt.value.toUpperCase();

			trouve = false;
			for (i=0;i<9; i++) {
				if (cases[i] == saisie) {
					trouve = true;
				}
			}
			if (trouve == false) {
				alert("Cette case n'est pas correcte");
				return false;
			} else {
				return true;
			}
		}
	</SCRIPT>
	</HEAD>
	<BODY>	
	<CENTER>
		<IMG src="titre.gif">
		<TABLE border="0">
		<TR>
			<TD>
				<IMG src="pblanc.gif"> <B>PRENOM_HUMAIN</B>
			</TD>
			<TD>
				<IMG src="pnoir.gif"> <B>Ordinateur</B>
			</TD>
		</TR>
		</TABLE>
		<BR><BR>
		
} "PRENOM_HUMAIN" query/prenom

affiche_cases

switch/default msg [
	"CONTINU" [ demande_mouvement ]
	"OCCUPEE" [ 
		print {<P CLASS="Information">Case occupe</P>}
		demande_mouvement
	]
] [ affiche_information msg ]

print {
	</CENTER>
	</BODY>
	</HTML>
}
